/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.extendedexchange.block.entity.AbstractEMCBlockEntity;
import dev.ftb.extendedexchange.client.gui.AbstractEXScreen;
import dev.ftb.extendedexchange.client.gui.EMCFormat;
import dev.ftb.extendedexchange.client.gui.KnowledgeUpdateListener;
import dev.ftb.extendedexchange.client.gui.buttons.ExtractItemButton;
import dev.ftb.extendedexchange.config.ConfigHelper;
import dev.ftb.extendedexchange.config.SearchType;
import dev.ftb.extendedexchange.integration.jei.JEIHooks;
import dev.ftb.extendedexchange.menu.AbstractTableMenu;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.PECapabilities;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTableScreen<C extends AbstractTableMenu>
extends AbstractEXScreen<C, AbstractEMCBlockEntity>
implements KnowledgeUpdateListener {
    private static int staticPage = 0;
    private static String staticSearch = "";
    private final List<ItemStack> validItems = new ArrayList<ItemStack>();
    protected final List<ExtractItemButton> extractButtons = new ArrayList<ExtractItemButton>();
    private EditBox searchField;

    public AbstractTableScreen(C menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.f_97727_ = 217;
    }

    protected void m_7856_() {
        super.m_7856_();
        Rect2i tb = this.searchFieldPos();
        this.searchField = new EditBox(this.f_96547_, tb.m_110085_(), tb.m_110086_(), tb.m_110090_(), tb.m_110091_(), TextComponent.f_131282_);
        this.searchField.m_94202_(-1);
        this.searchField.m_94205_(-8355712);
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(35);
        this.searchField.m_94144_(staticSearch);
        if (((SearchType)((Object)ConfigHelper.client().general.searchType.get())).autoselected) {
            this.m_94718_((GuiEventListener)this.searchField);
        }
        this.m_142416_((GuiEventListener)this.searchField);
    }

    protected abstract Rect2i searchFieldPos();

    protected void addExtractButton(ExtractItemButton extractItemButton) {
        this.extractButtons.add(extractItemButton);
        this.m_142416_((GuiEventListener)extractItemButton);
    }

    protected void m_181908_() {
        if (!staticSearch.equals(this.searchField.m_94155_())) {
            staticSearch = this.searchField.m_94155_();
            staticPage = 0;
            this.updateValidItemList();
            if (((SearchType)((Object)ConfigHelper.client().general.searchType.get())).jeiSync) {
                JEIHooks.handleJEISync(staticSearch);
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.changePage(delta < 0.0);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.searchFieldPos().m_110087_((int)mouseX, (int)mouseY) && button == 1) {
            this.searchField.m_94144_("");
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        Minecraft.m_91087_().f_91074_.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(p -> {
            String s = EMCFormat.INSTANCE.format(p.getEmc());
            this.f_96547_.m_92883_(poseStack, s, (float)(this.f_97726_ - this.f_96547_.m_92895_(s)) / 2.0f, -9.0f, -4868683);
        });
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        if (this.searchField.m_7933_(keyCode, scanCode, modifiers) || this.searchField.m_94204_()) {
            if (keyCode == 258) {
                this.m_5755_(!Screen.m_96638_());
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public void onKnowledgeUpdate() {
        staticPage = 0;
        staticSearch = "";
        this.searchField.m_94144_("");
        this.updateValidItemList();
    }

    protected void changePage(boolean forward) {
        if (forward) {
            if ((double)staticPage < Math.ceil((float)this.validItems.size() / (float)this.extractButtons.size()) - 1.0) {
                ++staticPage;
                this.updateDisplayedItems();
            }
        } else if (staticPage > 0) {
            --staticPage;
            this.updateDisplayedItems();
        }
    }

    protected void updateValidItemList() {
        this.validItems.clear();
        String srchStr = this.trim(staticSearch);
        boolean mod = srchStr.startsWith("@");
        if (mod) {
            srchStr = srchStr.substring(1);
        }
        for (ItemInfo itemInfo : ((AbstractTableMenu)this.f_97732_).getProvider().getKnowledge()) {
            ItemStack stack = itemInfo.createStack();
            if (stack.m_41619_() || !((AbstractTableMenu)this.f_97732_).isItemValid(stack) || !(srchStr.isEmpty() || mod ? itemInfo.getItem().getRegistryName().m_135827_().startsWith(srchStr) : StringUtils.contains((CharSequence)this.trim(stack.m_41611_().getString()), (CharSequence)srchStr))) continue;
            this.validItems.add(ProjectEAPI.getEMCProxy().getPersistentInfo(itemInfo).createStack());
        }
        this.validItems.sort(Comparator.comparingLong(o -> ProjectEAPI.getEMCProxy().getValue(o)));
        this.updateDisplayedItems();
    }

    private String trim(String s) {
        return ChatFormatting.m_126649_((String)s).trim().toLowerCase(Locale.ROOT);
    }

    public void updateDisplayedItems() {
        for (int i = 0; i < this.extractButtons.size(); ++i) {
            int index = i + staticPage * this.extractButtons.size();
            if (index >= 0 && index < this.validItems.size()) {
                this.extractButtons.get(i).setItem(this.validItems.get(index));
                this.extractButtons.get((int)i).f_93624_ = true;
                continue;
            }
            this.extractButtons.get(i).setItem(ItemStack.f_41583_);
            this.extractButtons.get((int)i).f_93624_ = false;
        }
    }
}

